
;   FILENAME: ENV.ASM
;
;   DESCRIPTION:

%tabsize 4

ifndef  MDL
    display "Error: This module requires that you provide a memory model"
    display "       definition on the command line. I.E. /dMDL=SMALL."
    err ; Force a fatal error
else

    ideal                           ; Use TASM's Ideal mode
    model   MDL,Pascal		    ; Define the memory model

include "stdlib.inc"

codeseg

; DS:SI  -- String to search for
; ES:DI  -- Place to put
; CX     -- Maximum size to copy
; AX	 -- PspAddress

proc  sl_EnvString
        cld                             ;work upward
        push    es
        push    di
        push    cx
	mov	es, ax
        mov     es,[es:2Ch]             ;ES:DI points at environment
        xor     di,di                   ;which is paragraph-aligned
        lodsb                           ;look at length
        or      al,al                   ;is it zero?
        jz      RetNul                  ;if so, return
        mov     ah,al                   ;otherwise, save in AH
        mov     dx,si                   ;DS:DX contains pointer to first parm char
        xor     al,al                   ;make a zero
Compare:
        mov     ch,al                   ;we want ch=0 for next count, if any
        mov     si,dx                   ;get back pointer to string sought
        mov     cl,ah                   ;get length
        mov     si,dx                   ;get pointer to string sought
        repe    cmpsb                   ;compare bytes
        jne     Skip                    ;if compare fails, try next string
        cmp     [Byte es:di],'='        ;compare succeeded. Is next char '='?
        jne     NoEqual                 ;if not, still no match
Found:
        mov     ax,es                   ;make DS:SI point to string we found
        mov     ds,ax
        mov     si,di
        inc     si                      ;get past the equal (=) sign

        pop     cx
        pop     bx
        pop     es
        mov     di,bx                   ;put it in ES:DI
;	 inc	 di			 ;get past the length byte
;        mov     cl,255                  ;set up a maximum length
CopyLoop:
        lodsb                           ;get a byte
        or      al,al                   ;zero test
        jz      Done                    ;if zero, we're done
        stosb                           ;put it in the result
        loop    CopyLoop                ;move up to 255 bytes
Done:   not     cl                      ;we've been decrementing CL from
                                        ; 255 during save
;	 mov	 [es:bx],cl		 ;save the length
	mov	al,0
	stosb
	mov	ax,@data
        mov     ds,ax                   ;restore DS
        ret
Skip:
        dec     di                      ;check for null from this char on
NoEqual:
        mov     cx,7FFFh                ;search a long way if necessary
        sub     cx,di                   ;environment never >32K
        jbe     RetNul                  ;if we're past end, leave
        repne   scasb                   ;look for the next null
        jcxz    RetNul                  ;exit if not found
        cmp     [Byte es:di],al         ;second null in a row?
        jne     Compare                 ;if not, try again
RetNul:
        pop     cx
        pop     di
        pop     es
        stosb                           ;store a zero there
        mov     ax,@data
        mov     ds,ax                   ;restore DS
        ret
endp	sl_EnvString

endif   ; ifndef MDL

end


